/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item;

import com.mojang.datafixers.util.Pair;
import dev.toma.gunsrpg.ModTabs;
import dev.toma.gunsrpg.common.item.BaseItem;
import dev.toma.gunsrpg.util.SkillUtil;
import dev.toma.gunsrpg.util.helper.NumberHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModFoodItem
extends BaseItem {
    private final List<IFoodBuff> foodBuffs = new ArrayList<IFoodBuff>();

    public ModFoodItem(String name, Food food) {
        super(name, new Item.Properties().func_200916_a(ModTabs.ITEM_TAB).func_221540_a(Objects.requireNonNull(food)));
        for (Pair pair : food.func_221464_f()) {
            this.addCustomBuff(new PotionBuff((EffectInstance)pair.getFirst()));
        }
    }

    public ModFoodItem heal(int amount, boolean withAttributes) {
        return this.addCustomBuff(new HealthBuff(amount, withAttributes));
    }

    public ModFoodItem heal(int amount) {
        return this.heal(amount, false);
    }

    public ModFoodItem addCustomBuff(IFoodBuff foodBuff) {
        this.foodBuffs.add(foodBuff);
        this.foodBuffs.sort(Comparator.comparingInt(IFoodBuff::orderIndex));
        return this;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (this.func_219971_r()) {
            if (entity instanceof PlayerEntity && !world.field_72995_K) {
                PlayerEntity player = (PlayerEntity)entity;
                for (IFoodBuff foodBuff : this.foodBuffs) {
                    foodBuff.accept(player);
                }
            }
            return entity.func_213357_a(world, stack);
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> components, ITooltipFlag flag) {
        for (IFoodBuff foodBuff : this.foodBuffs) {
            components.add(foodBuff.getTooltip());
        }
    }

    private static class PotionBuff
    implements IFoodBuff {
        private final ITextComponent tooltip;

        private PotionBuff(EffectInstance instance) {
            Effect effect = instance.func_188419_a();
            int amplifierVal = instance.func_76458_c() + 1;
            IFormattableTextComponent effectComponent = new StringTextComponent(effect.func_199286_c().getString() + " " + NumberHelper.toRomanLiteral(amplifierVal)).func_240699_a_(TextFormatting.YELLOW);
            IFormattableTextComponent timeComponent = new StringTextComponent(String.valueOf(instance.func_76459_b() / 20)).func_240699_a_(TextFormatting.GREEN);
            this.tooltip = new TranslationTextComponent("item.gunsrpg.food_buff.effect", new Object[]{effectComponent, timeComponent}).func_240699_a_(TextFormatting.GRAY);
        }

        @Override
        public void accept(PlayerEntity player) {
        }

        @Override
        public ITextComponent getTooltip() {
            return this.tooltip;
        }

        @Override
        public int orderIndex() {
            return Integer.MAX_VALUE;
        }
    }

    private static class HealthBuff
    implements IFoodBuff {
        private final int amount;
        private final boolean applyAttributes;
        private final ITextComponent tooltip;

        private HealthBuff(int amount, boolean applyAttributes) {
            this.amount = amount;
            this.applyAttributes = applyAttributes;
            IFormattableTextComponent hpComponent = new StringTextComponent(String.valueOf(amount)).func_240699_a_(TextFormatting.GREEN);
            this.tooltip = new TranslationTextComponent("item.gunsrpg.food_buff.health", new Object[]{hpComponent}).func_240699_a_(TextFormatting.GRAY);
        }

        @Override
        public void accept(PlayerEntity player) {
            if (this.applyAttributes) {
                SkillUtil.heal(player, this.amount);
            } else {
                player.func_70691_i((float)this.amount);
            }
        }

        @Override
        public ITextComponent getTooltip() {
            return this.tooltip;
        }
    }

    public static interface IFoodBuff
    extends Consumer<PlayerEntity> {
        public ITextComponent getTooltip();

        default public int orderIndex() {
            return 0;
        }
    }
}

